/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIBusinessEntity;
import filenet.vw.base.VWUDDIRegistry;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.ws.VWUDDIBusinessImportDialog;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Name;

public class VWUDDIBusinessEditDialog
extends VWModalDialog
implements ActionListener,
KeyListener {
    public static final int OK_BUTTON = 1;
    public static final int CANCEL_BUTTON = 2;
    public static final int CLOSE_BUTTON = 4;
    public static final int HELP_BUTTON = 8;
    public static final int STATUS_OK = 1;
    public static final int STATUS_CANCEL = 2;
    public static final int STATUS_CLOSE = 4;
    private JTextField m_nameTextField = null;
    private JTextArea m_descriptionTextArea = null;
    private JTextField m_keyTextField = null;
    private JTextField m_userTextField = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_closeButton = null;
    private JButton m_helpButton = null;
    private JButton m_importButton = null;
    private Color m_disabledBgColor = null;
    private Color m_enabledBgColor = null;
    private JPanel m_infoPanel = new JPanel();
    private JPanel m_newBusinessPanel = new JPanel();
    private Frame m_parentFrame = null;
    private int m_returnStatus = 0;
    private boolean m_bChanged = false;
    private String m_businessKey = null;
    private VWUDDIRegistry m_vwUDDIRegistry = null;
    private VWUDDIBusinessEntity m_vwBusinessEntity = null;
    private WSUDDIRegistry m_wsUDDIRegistry = null;

    public VWUDDIBusinessEditDialog(Frame parent, VWUDDIRegistry vwUDDIRegistry, VWUDDIBusinessEntity vwBusinessEntity) {
        super(parent);
        try {
            this.m_parentFrame = parent;
            this.setTitle(VWResource.BusinessInformation);
            Dimension dim = VWStringUtils.stringToDimension("605,335");
            if (dim == null) {
                dim = new Dimension(550, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.m_vwUDDIRegistry = vwUDDIRegistry;
            this.m_vwBusinessEntity = vwBusinessEntity;
            this.m_wsUDDIRegistry = new WSUDDIRegistry(vwUDDIRegistry.getName(), vwUDDIRegistry.getInquiryURL(), vwUDDIRegistry.getPublishURL(), vwUDDIRegistry.isPublishable());
            this.m_businessKey = this.m_vwBusinessEntity.getBusinessKey();
            if (this.m_vwBusinessEntity == null) {
                this.m_vwBusinessEntity = new VWUDDIBusinessEntity();
            }
            if (this.m_businessKey == null || this.m_businessKey.length() <= 0) {
                this.showNewBusinessPanel();
            } else {
                this.showBusinessInfoPanel();
            }
            this.setLocationRelativeTo(parent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_nameTextField != null) {
            this.m_nameTextField.removeAll();
            this.m_nameTextField = null;
        }
        if (this.m_descriptionTextArea != null) {
            this.m_descriptionTextArea.removeAll();
            this.m_descriptionTextArea = null;
        }
        if (this.m_keyTextField != null) {
            this.m_keyTextField.removeAll();
            this.m_keyTextField = null;
        }
        if (this.m_userTextField != null) {
            this.m_userTextField.removeAll();
            this.m_userTextField = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this);
            this.m_okButton.removeAll();
            this.m_okButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_closeButton != null) {
            this.m_closeButton.removeActionListener(this);
            this.m_closeButton.removeAll();
            this.m_closeButton = null;
        }
        if (this.m_importButton != null) {
            this.m_importButton.removeActionListener(this);
            this.m_importButton.removeAll();
            this.m_importButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.removeAll();
    }

    private JPanel createBusinessInfoPanel() {
        JPanel subPanel = new JPanel();
        String text = null;
        try {
            this.m_infoPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.m_infoPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 21;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            this.m_infoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_businessName)), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            Name name = this.m_vwBusinessEntity.getName(0);
            text = name != null ? name.getValue() : new String();
            this.m_nameTextField = new JTextField(text);
            this.m_nameTextField.setEditable(false);
            this.m_infoPanel.add((Component)this.m_nameTextField, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            this.m_infoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_businessKey)), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_keyTextField = new JTextField(this.m_vwBusinessEntity.getBusinessKey());
            this.m_keyTextField.setEditable(false);
            this.m_infoPanel.add((Component)this.m_keyTextField, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            this.m_infoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_publishUserName)), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_userTextField = new JTextField(this.m_vwBusinessEntity.getPublishUserName());
            this.m_userTextField.setEditable(false);
            this.m_infoPanel.add((Component)this.m_userTextField, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.anchor = 23;
            this.m_infoPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_businessDescription)), gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            this.m_descriptionTextArea = new JTextArea(this.m_vwBusinessEntity.getDescriptionString(0));
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.addKeyListener(this);
            this.m_descriptionTextArea.setEditable(false);
            this.m_descriptionTextArea.setBackground(subPanel.getBackground());
            this.m_infoPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_infoPanel;
    }

    private JPanel createNewBusinessPanel() {
        JPanel subPanel = new JPanel();
        try {
            subPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            subPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 21;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_businessName)), gbConst);
            ++gbConst.gridx;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            this.m_nameTextField = new JTextField(this.m_vwBusinessEntity.getNameString(0));
            this.m_nameTextField.addKeyListener(this);
            this.m_nameTextField.setCaretPosition(0);
            subPanel.add((Component)this.m_nameTextField, gbConst);
            ++gbConst.gridx;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            this.m_importButton = new JButton(VWResource.s_importBusiness);
            this.m_importButton.addActionListener(this);
            subPanel.add((Component)this.m_importButton, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 0;
            gbConst.weightx = 0.0;
            gbConst.anchor = 23;
            subPanel.add((Component)new JLabel(VWResource.s_label.toString(VWResource.s_businessDescription)), gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            gbConst.gridwidth = 0;
            this.m_descriptionTextArea = new JTextArea(this.m_vwBusinessEntity.getDescriptionString(0));
            this.m_descriptionTextArea.setLineWrap(true);
            this.m_descriptionTextArea.setWrapStyleWord(true);
            this.m_descriptionTextArea.addKeyListener(this);
            subPanel.add((Component)new JScrollPane(this.m_descriptionTextArea), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return subPanel;
    }

    protected JPanel createButtonPanel(int options) {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.gridwidth = 2;
            gbConst.gridheight = 1;
            gbConst.insets = new Insets(10, 10, 10, 10);
            if ((options & 1) == 1) {
                this.m_okButton = new JButton(VWResource.s_ok);
                this.m_okButton.addActionListener(this);
                mainPanel.add((Component)this.m_okButton, gbConst);
                this.setOKButtonState();
            }
            if ((options & 2) == 2) {
                this.m_cancelButton = new JButton(VWResource.s_cancel);
                this.m_cancelButton.addActionListener(this);
                mainPanel.add((Component)this.m_cancelButton, gbConst);
            }
            if ((options & 4) == 4) {
                this.m_closeButton = new JButton(VWResource.s_close);
                this.m_closeButton.addActionListener(this);
                mainPanel.add((Component)this.m_closeButton, gbConst);
            }
            this.m_helpButton = new JButton(VWResource.s_help);
            this.m_helpButton.addActionListener(this);
            mainPanel.add((Component)this.m_helpButton, gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    public int getReturnStatus() {
        return this.m_returnStatus;
    }

    public boolean hasChanged() {
        return this.m_bChanged;
    }

    public VWUDDIBusinessEntity getBusinessEntity() {
        return this.m_vwBusinessEntity;
    }

    public boolean validateData() {
        boolean bOK = true;
        String nameText = this.m_nameTextField.getText();
        if (nameText == null || nameText.trim().length() < 1) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, VWResource.s_noBusinessName, VWResource.ErrorMessage, 1);
            bOK = false;
        }
        return bOK;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            this.m_returnStatus = 2;
            this.setVisible(false);
        } else if (obj == this.m_okButton) {
            if (this.validateData()) {
                Vector<Object> v = null;
                String txt = this.m_nameTextField.getText();
                if (txt != null) {
                    txt = txt.trim();
                    v = new Vector<Object>();
                    v.add(new Name(txt));
                    this.m_vwBusinessEntity.setNameVector(v);
                }
                if ((txt = this.m_descriptionTextArea.getText()) != null) {
                    txt = txt.trim();
                }
                v = new Vector();
                v.add(new Description(txt));
                this.m_vwBusinessEntity.setDescriptionVector(v);
                if (this.m_keyTextField != null && (txt = this.m_keyTextField.getText()) != null) {
                    txt = txt.trim();
                    this.m_vwBusinessEntity.setBusinessKey(txt);
                }
                if (this.m_userTextField != null && (txt = this.m_userTextField.getText()) != null) {
                    txt = txt.trim();
                    this.m_vwBusinessEntity.setAuthorizedName(txt);
                }
                this.m_returnStatus = 1;
                this.setVisible(false);
            }
        } else if (obj == this.m_closeButton) {
            this.m_returnStatus = 4;
            this.setVisible(false);
        } else if (obj == this.m_importButton) {
            this.onImportBusiness();
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc091.htm");
        } else if (obj == this.m_descriptionTextArea) {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        Object source = event.getSource();
        if (source == this.m_nameTextField) {
            this.m_okButton.setEnabled(true);
        }
        this.m_bChanged = true;
    }

    private void onImportBusiness() {
        try {
            if (this.m_bChanged) {
                this.m_vwUDDIRegistry.setBusinessName(this.m_nameTextField.getText());
            }
            VWUDDIBusinessImportDialog importDialog = new VWUDDIBusinessImportDialog(this.m_parentFrame, this.m_vwUDDIRegistry);
            importDialog.setVisible(true);
            int retStatus = importDialog.getReturnStatus();
            if (retStatus == 0) {
                String publishUser;
                WSBusinessEntity wsBusinessEntity = importDialog.getWSBusinessEntity();
                if (wsBusinessEntity != null) {
                    this.m_vwBusinessEntity.setBusinessEntity(wsBusinessEntity.getBusinessEntity());
                }
                if ((publishUser = importDialog.getPublishUser()) != null && publishUser.length() > 0) {
                    this.m_vwBusinessEntity.setPublishUserName(publishUser);
                }
                this.m_bChanged = true;
                this.showBusinessInfoPanel();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setOKButtonState() {
        this.getRootPane().setDefaultButton(this.m_okButton);
        boolean bEnable = true;
        String tempString = null;
        if (this.m_nameTextField != null) {
            tempString = this.m_nameTextField.getText();
            if (tempString == null || VWStringUtils.compare(tempString, "") == 0) {
                bEnable = false;
            }
        } else {
            bEnable = false;
        }
        if (this.m_okButton.isEnabled() != bEnable) {
            this.m_okButton.setEnabled(bEnable);
        }
    }

    private void showBusinessInfoPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.createBusinessInfoPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(12), "Last");
        this.m_keyTextField.setCaretPosition(0);
        this.m_nameTextField.setCaretPosition(0);
        this.m_userTextField.setCaretPosition(0);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    private void showNewBusinessPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add((Component)this.createNewBusinessPanel(), "Center");
        this.getContentPane().add((Component)this.createButtonPanel(11), "Last");
        this.m_keyTextField.setCaretPosition(0);
        this.m_nameTextField.setCaretPosition(0);
        this.m_userTextField.setCaretPosition(0);
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

